/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.Customer;

import company.tap.commondependencies.ApiModels.ApiCustomer;
import company.tap.commondependencies.ApiModels.ApiCustomerList;
import company.tap.commondependencies.ApiModels.ApiList;
import company.tap.commondependencies.Country.ICountryServices;
import company.tap.commondependencies.Customer.ICustomerServices;
import company.tap.commondependencies.Errors.IErrorServices;
import company.tap.commondependencies.Helpers.DataUtilities;
import company.tap.commondependencies.Helpers.RestAPI;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;

@Service
class CustomerServices
implements ICustomerServices {
    final IErrorServices _errorServices;
    final ICountryServices _countryServices;
    private final String TapApi = DataUtilities.getInstance().getUrlTapApiV2();

    public CustomerServices(IErrorServices _errorServices, ICountryServices _countryServices) {
        this._errorServices = _errorServices;
        this._countryServices = _countryServices;
    }

    @Override
    public ApiCustomer GetCustomerInfo(String customerId, String authorization) throws HttpClientErrorException {
        HttpHeaders headersCA = new HttpHeaders();
        headersCA.setContentType(MediaType.APPLICATION_JSON);
        headersCA.set("Authorization", "Bearer " + authorization);
        HttpEntity entityToken = new HttpEntity((MultiValueMap)headersCA);
        return (ApiCustomer)RestAPI.getInstance().exchange(this.TapApi + "customers/" + customerId, HttpMethod.GET, entityToken, ApiCustomer.class, new Object[0]).getBody();
    }

    @Override
    public ApiCustomerList GetCustomerList(ApiList list, String authorization) throws HttpClientErrorException {
        HttpHeaders headersCA = new HttpHeaders();
        headersCA.setContentType(MediaType.APPLICATION_JSON);
        headersCA.set("Authorization", "Bearer " + authorization);
        HttpEntity entityToken = new HttpEntity((Object)list, (MultiValueMap)headersCA);
        return (ApiCustomerList)RestAPI.getInstance().exchange(this.TapApi + "customers/list", HttpMethod.POST, entityToken, ApiCustomerList.class, new Object[0]).getBody();
    }
}

