/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.Generators;

import company.tap.commondependencies.Generators.IGenerator;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.springframework.stereotype.Service;

@Service
class Generator
implements IGenerator {
    Generator() {
    }

    private String getAlphaNumericString(int length) {
        String AlphaNumericString = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890abcdefghijklmnopqrstuvxyz";
        return this.getRandomString(length, AlphaNumericString);
    }

    private String getRandomString(int length, String alphaNumericString) {
        StringBuilder sb = new StringBuilder(4);
        for (int i = 0; i < length; ++i) {
            int index = (int)((double)alphaNumericString.length() * Math.random());
            sb.append(alphaNumericString.charAt(index));
        }
        return sb.toString();
    }

    @Override
    public String GetId(String type) {
        Calendar calendar = Calendar.getInstance();
        return type + "_" + this.getAlphaNumericString(4) + calendar.get(13) + String.valueOf(calendar.get(1)).substring(2) + calendar.get(11) + calendar.get(12) + this.getAlphaNumericString(4) + calendar.get(5) + this.getAlphaNumericString(2) + calendar.get(2) + this.getAlphaNumericString(1) + calendar.get(14);
    }

    @Override
    public String GetRandomNumber(int length) {
        String AlphaNumericString = "1234567890";
        return this.getRandomString(length, AlphaNumericString);
    }

    @Override
    public String GetIdByLength(String type, int length) {
        return type + "_" + this.getAlphaNumericString(length);
    }

    @Override
    public Map<String, String> GetRSAKeys() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048, new SecureRandom());
        KeyPair keypair = keyGen.generateKeyPair();
        PublicKey publicKey = keypair.getPublic();
        PrivateKey privateKey = keypair.getPrivate();
        PemObject pemObjectPrivateKey = new PemObject("RSA PRIVATE KEY", privateKey.getEncoded());
        StringWriter prvKey = new StringWriter();
        PEMWriter pemPrivateKey = new PEMWriter((Writer)prvKey);
        pemPrivateKey.writeObject((PemObjectGenerator)pemObjectPrivateKey);
        pemPrivateKey.close();
        prvKey.close();
        PemObject pemObjectPublicKey = new PemObject("PUBLIC KEY", publicKey.getEncoded());
        StringWriter pubKey = new StringWriter();
        PEMWriter pemPublicKey = new PEMWriter((Writer)pubKey);
        pemPublicKey.writeObject((PemObjectGenerator)pemObjectPublicKey);
        pemPublicKey.close();
        pubKey.close();
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("private", prvKey.toString());
        keys.put("public", pubKey.toString());
        return keys;
    }
}

