/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.Errors;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import company.tap.commondependencies.ApiModels.ApiErrors;
import company.tap.commondependencies.ApiModels.ErrorSource;
import company.tap.commondependencies.Errors.IErrorServices;
import company.tap.commondependencies.Helpers.ObjMapper;
import java.util.ArrayList;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
class ErrorServices
implements IErrorServices {
    ErrorServices() {
    }

    @Override
    public ResponseEntity<Object> Error(int code, String error, String description, HttpStatus httpStatus) {
        ApiErrors apiError = new ApiErrors();
        ApiErrors.ApiError err = new ApiErrors.ApiError(apiError);
        err.code = String.valueOf(code);
        err.error = error;
        err.description = description;
        return this.getObjectResponseEntity(httpStatus, apiError, err);
    }

    private ResponseEntity<Object> getObjectResponseEntity(HttpStatus httpStatus, ApiErrors apiError, ApiErrors.ApiError err) {
        ArrayList<ApiErrors.ApiError> errors = new ArrayList<ApiErrors.ApiError>();
        errors.add(err);
        apiError.errors = errors;
        return new ResponseEntity((Object)apiError, httpStatus);
    }

    @Override
    public ResponseEntity<Object> Errors(int code, String error, String description, ErrorSource source, HttpStatus httpStatus) {
        ObjMapper.getInstance().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ObjMapper.getInstance().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ApiErrors apiError = new ApiErrors();
        ApiErrors.ApiError err = new ApiErrors.ApiError(apiError);
        err.code = String.valueOf(code);
        err.error = error;
        err.description = description;
        err.errors = source;
        return this.getObjectResponseEntity(httpStatus, apiError, err);
    }
}

