/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.goSellModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import company.tap.commondependencies.ApiModels.ApiAddress;
import company.tap.commondependencies.ApiModels.ApiBankAccount;
import company.tap.commondependencies.ApiModels.ApiBrand;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class goSellAccountMigration {
    @JsonProperty("response_code")
    public int responseCode;
    @JsonProperty("response_message")
    public String responseMessage;
    @JsonProperty("legacy_id")
    public int legacyId;
    public String status;
    @JsonProperty("status_code")
    public String statusCode;
    @JsonProperty("status_description")
    public String statusDescription;
    public boolean transfer;
    @JsonProperty("access_token")
    public String accessToken;
    @JsonProperty("master_segment_type")
    public String masterSegmentType;
    @JsonProperty("master_account_id")
    public String masterAccountId;
    @JsonProperty("account_type")
    public String accountType;
    @JsonProperty("profile_name")
    public String profileName;
    @JsonProperty("profile_name_ar")
    public String profileNameAr;
    @JsonProperty("business_logo_url")
    public String businessLogoUrl;
    @JsonProperty("country_code")
    public String countryCode;
    public Merchant merchant;
    public Wallet wallet;
    @JsonProperty("bank_account_info")
    public ApiBankAccount bankAccountInfo;
    @JsonProperty("brand_info")
    public BrandInfo brandInfo;
    @JsonProperty("corporate_info")
    public CorporateInfo corporateInfo;
    @JsonProperty("contact_info")
    public ContactInfo contactInfo;
    @JsonProperty("users")
    public List<ContactInfo> users;
    @JsonProperty("freelancer_info")
    public CorporateInfo freelancerInfo;
    public Opened opened;
    public List<String> signed;
    @JsonProperty("master_is_segment")
    public boolean masterIsSegment;
    @JsonProperty("is_destination")
    public boolean isDestination;
    @JsonProperty("created_at")
    public Date createdAt;
    @JsonProperty("approved_at")
    public Date approvedAt;

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class ContactInfo {
        @JsonProperty("first_name_en")
        public String firstNameEn;
        @JsonProperty("middle_name_en")
        public String middleNameEn;
        @JsonProperty("third_name_en")
        public String thirdNameEn;
        @JsonProperty("last_name_en")
        public String lastNameEn;
        @JsonProperty("first_name_ar")
        public String firstNameAr;
        @JsonProperty("middle_name_ar")
        public String middleNameAr;
        @JsonProperty("third_name_ar")
        public String thirdNameAr;
        @JsonProperty("last_name_ar")
        public String lastNameAr;
        @JsonProperty("role_name")
        public String roleName;
        @JsonProperty("email_address")
        public String emailAddress;
        @JsonProperty("mobile_country_code")
        public String mobileCountryCode;
        @JsonProperty("mobile_number")
        public String mobileNumber;
        public String nationality;
        public String gender;
        public String dob;
        @JsonProperty("birth_city")
        public String birthCity;
        @JsonProperty("birth_country")
        public String birthCountry;
        @JsonProperty("id_number")
        public String idNumber;
        @JsonProperty("id_type")
        public String idType;
        @JsonProperty("id_expiry")
        public String idExpiry;
        @JsonProperty("id_front_copy_url")
        public String idFrontCopyUrl;
        @JsonProperty("id_back_copy_url")
        public String idBackCopyUrl;
        public ApiAddress address;
        public Map<String, Verification> verification;
        @JsonProperty("is_authorized")
        public boolean isAuthorized;
        @JsonProperty("created_at")
        public Date createdAt;
        @JsonProperty("paci_number")
        public String paciNumber;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Verification {
        @JsonProperty("is_verified")
        public boolean isVerified;
        @JsonProperty("verified_at")
        public String verifiedAt;
        @JsonProperty("verified_by")
        public String verifiedBy;
        public String type;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class CorporateInfo {
        public String name;
        @JsonProperty("name_ar")
        public String nameAr;
        public String type;
        @JsonProperty("license_status")
        public String licenseStatus;
        @JsonProperty("license_provider")
        public String licenseProvider;
        @JsonProperty("license_number")
        public String licenseNumber;
        @JsonProperty("license_issuing_date")
        public String licenseIssuingDate;
        @JsonProperty("license_expiry_date")
        public String licenseExpiryDate;
        @JsonProperty("license_unified_number")
        public String licenseUnifiedNumber;
        @JsonProperty("license_copy_url")
        public String licenseCopyUrl;
        @JsonProperty("authorized_signatory_copy_url")
        public String authorizedSignatoryCopyUrl;
        public boolean taxable;
        @JsonProperty("vat_no")
        public String vatNo;
        @JsonProperty("settlement_by")
        public String settlementBy;
        public ApiAddress address;
        @JsonProperty("not_for_profit")
        public boolean not_for_profit;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Opened {
        @JsonProperty("by")
        public String byUserId;
        @JsonProperty("for")
        public String forUserId;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Merchant {
        @JsonProperty("is_acceptance_allowed")
        public boolean isAcceptanceAllowed;
        @JsonProperty("is_payout_allowed")
        public boolean isPayoutAllowed;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Wallet {
        public String status;
        public String country;
        @JsonProperty("base_currency")
        public String baseCurrency;
        @JsonProperty("settlement_by")
        public String settlementBy;
        @JsonProperty("primary_wallet")
        public boolean primaryWallet;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class BrandInfo {
        @JsonProperty("content_about_en")
        public String contentAboutEn;
        @JsonProperty("sector_id")
        public String sectorId;
        @JsonProperty("sector_name_en")
        public String sectorNameEn;
        @JsonProperty("sector_name_ar")
        public String sectorNameAr;
        @JsonProperty("channel_services")
        public List<ApiBrand.ChannelService> channelServices;
        @JsonProperty("operation_start_date")
        public String operationStartDate;
        @JsonProperty("segment_name_en")
        public String segmentNameEn;
        @JsonProperty("segment_name_ar")
        public String segmentNameAr;
        @JsonProperty("terms")
        public Terms terms;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Terms {
        public boolean general;
        @JsonProperty("agreed_at")
        public String agreedAt;
    }
}
