/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.Models;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import company.tap.commondependencies.ApiModels.ApiCreatedBy;
import company.tap.commondependencies.ApiModels.ApiSettlement;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.*;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class PrivateWallet {
    public boolean success;

    public String walletId;

    public String businessId;

    public String entityId;

    public List<Brands> brands;

    public String typeId;

    public String currencyId;

    public String countryId;

    public String fundId;

    public String settlement_by;
    public ApiSettlement settlement;

    public String merchantId;

    public int legacyId;

    public boolean isPrimary;

    public String bankAccountId;

    public String accessToken;

    public List<String> operators;

    public String segmentId;

    public boolean isMerchant;

    public boolean isArchived;

    public boolean isDeleted;

    public long created;

    public String status;

    public String type;

    public boolean isNonResident;
    public Boolean isPayoutAllowed;
    public String walletName;
    public String customerId;
    public String profileName;
    public String createdBySegmentId;
    /**
     * createdAt used for legacy migration
     */
    @JsonProperty("created_at")
    public Date createdAt;
    public HashMap<String, String> metaData;

    @JsonIgnore
    private Map<String, ApiCreatedBy> segments = new LinkedHashMap<>();
    @JsonAnyGetter
    public Map<String, ApiCreatedBy> getSegments() {
        return segments;
    }

    @JsonAnySetter
    public void setSegments(String key, Object value) {
        if (value instanceof String || value instanceof Boolean) return;
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.segments.put(key, mapper.convertValue(value, ApiCreatedBy.class));
        } catch (Exception e) {
            //ignore exception
        }
    }

}
