package company.tap.commondependencies.Helpers;

import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import java.nio.charset.Charset;

public class RestAPI extends RestTemplate {

    // singleton instance declaration
    private static RestAPI shared;
    // making constructor private so that no other class could use the default constructor
    private RestAPI() {
    }
    // the method which gives access to the only instance of ApiClientReqLib, is thread safe
    public static synchronized RestAPI getInstance(){
        if(shared==null){
            shared = new RestAPI();
            shared.getMessageConverters()
                    .add(0, new StringHttpMessageConverter(Charset.forName("UTF-8")));
            HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
            requestFactory.setConnectTimeout(180000);
            requestFactory.setReadTimeout(180000);
            requestFactory.setConnectionRequestTimeout(180000);
            shared.setRequestFactory(requestFactory);
            shared.getMessageConverters().add(new ByteArrayHttpMessageConverter());
        }
        return shared;
    }

//////////////////////////
}
