package company.tap.commondependencies.Country;

import com.google.common.base.Strings;
import company.tap.commondependencies.ApiModels.Name;
import company.tap.commondependencies.Constants.CommonConstants;
import company.tap.commondependencies.Helpers.DataUtilities;
import company.tap.commondependencies.Helpers.RestAPI;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.io.*;
import java.util.Date;
import java.util.HashMap;
import java.util.NoSuchElementException;

import static org.springframework.http.MediaType.APPLICATION_JSON;

@Service
class CountryServices implements ICountryServices {

    private final String CommonApi = DataUtilities.getInstance().getUrlCommonUtilities();

    private HashMap<String,Country> countryIsoCodeMap = new HashMap<>();
    private HashMap<String,Country> countryIdMap = new HashMap<>();

    private long cacheExpiresAt=0L;


    public Country getCountryByCountryIso(String CountryCode) {
        try {
            if(Strings.isNullOrEmpty(CountryCode)) return null;
            constructCache();
            Country country = countryIsoCodeMap.get(CountryCode);
            if(country!=null) return country;
            HttpHeaders headersCA = new HttpHeaders();
            headersCA.setContentType(APPLICATION_JSON);
            HttpEntity<String> entityToken = new HttpEntity<>(headersCA);
            return RestAPI.getInstance()
                    .exchange(CommonApi + "country/iso/" + CountryCode, HttpMethod.GET, entityToken, Country.class)
                    .getBody();

        } catch (Exception e) {
            return null;
        }
    }

    public Country getCountryByCountryId(String CountryId) {
        try {
            if(Strings.isNullOrEmpty(CountryId)) return null;
            constructCache();
            Country country = countryIdMap.get(CountryId);
            if(country!=null) return country;
            HttpHeaders headersCA = new HttpHeaders();
            headersCA.setContentType(APPLICATION_JSON);
            HttpEntity<String> entityToken = new HttpEntity<>(headersCA);
            return RestAPI.getInstance()
                    .exchange(CommonApi + "country/" + CountryId, HttpMethod.GET, entityToken, Country.class)
                    .getBody();

        } catch (Exception e) {
            return null;
        }
    }

    public CountryListResponse getCountryList() {
        try {

            HttpHeaders headersCA = new HttpHeaders();
            headersCA.setContentType(APPLICATION_JSON);
            HttpEntity<HashMap> entityToken = new HttpEntity<>(new HashMap<>(),headersCA);
            return RestAPI.getInstance()
                    .exchange(CommonApi + "country/list", HttpMethod.POST, entityToken, CountryListResponse.class)
                    .getBody();

        } catch (Exception e) {
            return null;
        }
    }

    private JSONArray getCountries() {
        //JSON parser object to parse read file
        JSONParser jsonParser = new JSONParser();
        Resource resource = new ClassPathResource("Countries.json");
        try (InputStreamReader reader = new InputStreamReader(resource.getInputStream())) {
            //Read JSON file
            Object obj = jsonParser.parse(reader);
            return (JSONArray) obj;
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Country getCountryByCountryIsoLocal(String code) {
        try {
            JSONArray countries = getCountries();
            if (countries == null)
                return null;
            JSONObject country;
            if (code.length() == 2)
                country =
                        (JSONObject) countries.stream().filter(jsonValue -> ((JSONObject) jsonValue).get("iso2").equals(code.toUpperCase())).findFirst().get();
            else
                country =
                        (JSONObject) countries.stream().filter(jsonValue -> ((JSONObject) jsonValue).get("iso3").equals(
                                code.toUpperCase())).findFirst().get();
            return prepareResponseObject(country);
        } catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public Country getCountryByCountryIdLocal(String CountryId) {
        try {
            JSONArray countries = getCountries();
            if (countries == null)
                return null;
            JSONObject country =
                    (JSONObject) countries.stream().filter(jsonValue -> ((JSONObject) jsonValue).get("countryId").equals(
                            CountryId)).findFirst().get();
            return prepareResponseObject(country);
        } catch (NoSuchElementException e) {
            return null;
        }
    }

    private Country prepareResponseObject(JSONObject jsonObject) {
        Country country = new Country();
        country.countryId = jsonObject.get("countryId").toString();
        country.capital = jsonObject.get("capital").toString();
        country.continent = jsonObject.get("continent").toString();
        country.geoNameId = jsonObject.get("geoNameId").toString();
        country.idd_prefix = jsonObject.get("idd_prefix").toString();
        country.iso2 = jsonObject.get("iso2").toString();
        country.iso3 = jsonObject.get("iso3").toString();
        country.numeric = jsonObject.get("numeric").toString();
        JSONObject name = (JSONObject) jsonObject.get("name");
        Name countryName = new Name();
        countryName.arabic = name.get("arabic").toString();
        countryName.english = name.get("english").toString();
        countryName.chinese = name.get("chinese").toString();
        countryName.russian = name.get("russian").toString();
        countryName.spanish = name.get("spanish").toString();
        countryName.french = name.get("french").toString();
        country.name = countryName;
        country.created = Long.parseLong(jsonObject.get("created").toString());
        return country;
    }

    @Override
    public Country getCountryByPrefixIdLocal(int countryPhoneCode) {
        try {
            JSONArray countries = getCountries();
            if (countries == null)
                return null;
            JSONObject country =
                    (JSONObject) countries.stream().filter(jsonValue -> Integer.parseInt(((JSONObject) jsonValue).get(
                            "idd_prefix").toString()) == countryPhoneCode).findFirst().get();
            return prepareResponseObject(country);
        } catch (NoSuchElementException e) {
            return null;
        }
    }

    private void constructCache()
    {
        if((new Date()).getTime()<cacheExpiresAt) return;
        CountryListResponse countryListResponse = getCountryList();
        if(countryListResponse==null || CollectionUtils.isEmpty(countryListResponse.getList())) return;
        HashMap<String,Country> newCountryIsoCodeMap = new HashMap<>();
        HashMap<String,Country> newCountryIdMap = new HashMap<>();
        for (Country country:
                countryListResponse.getList()) {
            newCountryIdMap.put(country.countryId,country);
            newCountryIsoCodeMap.put(country.iso2,country);
            newCountryIsoCodeMap.put(country.iso3,country);
        }
        countryIdMap.clear();
        countryIdMap.putAll(newCountryIdMap);
        countryIsoCodeMap.clear();
        countryIsoCodeMap.putAll(newCountryIsoCodeMap);
        cacheExpiresAt = (new Date()).getTime() + CommonConstants.CACHE_EXPIRY;
    }


}
