package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiWallet extends ApiBaseModel {
    public String base_currency;
    public String country;
    public String settlement_by;
    public Boolean primary_wallet;
    @NotEmpty(message = "Please provide a business_entity_id")
    public String business_entity_id;
    @JsonProperty("is_merchant")
    public Boolean is_merchant;
    public List<ReqBrand> brands;
    public ApiBankAccount bank_account;
    @JsonProperty("is_non_resident")
    public Boolean isNonResident;
    public ApiSettlement settlement; //Added on 27OCT
    @JsonProperty("balance")
    public HashMap<String, Object> balance;
    @JsonProperty("segment_id")
    public String segmentId;
    @JsonProperty("legacy_id")
    public String legacyId;
    @JsonProperty("created_by_segment_id")
    public String createdBySegmentId;
    @JsonProperty("customer_id")
    public String customerId;
    @NotEmpty(message = "Please provide a wallet_name")
    public String wallet_name;
    public String email; //Added on 19DEC21
    @JsonProperty("payout_status")
    public String payoutStatus;
    @JsonProperty("is_transaction_available")
    public Boolean isTransactionAvailable;
    @JsonProperty("last_transaction_created")
    public Long lastTransactionCreated;
    public String currency;
    @JsonProperty("metadata")
    public HashMap<String, String> metaData;
  
  
    @JsonProperty("payout_status_control")
    public String payoutStatusControl;

    @JsonIgnore
    private Map<String, ApiCreatedBy> segments = new LinkedHashMap<>();
    @JsonAnyGetter
    public Map<String, ApiCreatedBy> getSegments() {
        return segments;
    }

    @JsonAnySetter
    public void setSegments(String key, Object value) {
        if (value instanceof String || value instanceof Boolean) return;
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.segments.put(key, mapper.convertValue(value, ApiCreatedBy.class));
        } catch (Exception e) {
            //ignore exception
        }
    }
}
