package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiEntityResponse extends ApiBaseModel {
    public ApiEntity entity;
    @JsonProperty("signed_in_entity")
    public ApiSignedInEntity apiSigneInEntity;

    public ApiMerchant merchant;
    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class ApiSignedInEntity {
        @JsonProperty("primary_business_id")
        public String primaryBusinessId;
    }
}
