package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;


@NoArgsConstructor
@Data
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiComment extends ApiBaseModel {

    public ApiComment(String comment, String legacyId, String object, String objectId, String field)
    {
        this.field=field;
        this.comment=comment;
        this.legacyId= legacyId;
        this.object= object;
        this.objectId= objectId;
    }

    String field;
    String comment;
    @JsonProperty("action_by")
    String actionBy;
    @JsonProperty("action_date")
    Long actionDate=0L;
    @JsonProperty("legacy_id")
    String legacyId;
    String object;
    @JsonProperty("object_id")
    String objectId;

    public String getComment()
    {
        if(Strings.isNullOrEmpty(comment) && !Strings.isNullOrEmpty(field) && !Strings.isNullOrEmpty(object) ) {
            String s = object + " : " + field + " updated";
            comment = StringUtils.capitalize(s.replace("_", " "));
        }
        return comment;
    }


}
