/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.ThridPartyApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiWataqCrSa {
    public String crName;
    public String crNumber;
    public String crEntityNumber;
    public String issueDate;
    public String expiryDate;
    public Capital capital;
    public String crMainNumber;
    public List<Party> parties;
    public BusinessType businessType;
    public FiscalYear fiscalYear;
    public Status status;
    public Cancellation cancellation;
    public Address address;
    public Location location;
    public Company company;
    public Activities activities;

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Status{
        public String id;
        public String name;
        public String nameEn;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Location{
        public String id;
        public String name;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Company{
        public String period;
        public String startDate;
        public Object endDate;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Isic{
        public int id;
        public String name;
        public Object nameEn;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Activities{
        public String description;
        public List<Isic> isic;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Share{
        public int sharePrice;
        public int sharesCount;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Capital{
        public int paidAmount;
        public int subscribedAmount;
        public int announcedAmount;
        public Share share;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Identity{
        public String id;
        public String type;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Relation{
        public int id;
        public String name;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Nationality{
        public String id;
        public String name;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Party{
        public String name;
        public String birthDate;
        public Integer sharesCount;
        public Integer gross;
        public Identity identity;
        public Relation relation;
        public Nationality nationality;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class BusinessType{
        public int id;
        public String name;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class CalendarType{
        public int id;
        public String name;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class FiscalYear{
        public int month;
        public int day;
        public CalendarType calendarType;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Cancellation{
        public String date;
        public String reason;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class General{
        public String website;
        public String address;
        public String email;
        public String fax1;
        public String fax2;
        public String telephone1;
        public String telephone2;
        public String postalBox1;
        public String postalBox2;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class District{
        public int id;
        public String name;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class National{
        public int buildingNumber;
        public int additionalNumber;
        public String streetName;
        public String city;
        public String zipCode;
        public int unitNumber;
        public District district;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Address{
        public General general;
        public National national;
    }
}

