package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import company.tap.commondependencies.Helpers.validator.OnCreateLeadValidation;
import company.tap.commondependencies.Helpers.validator.OnUpdateLead;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiLead extends ApiBaseModel {

    //@NotNull
    public ApiContactName name;

    //@NotNull
    @JsonProperty("contact")
    public ApiPrimaryContact contactInfo;

    public String nationality;

    @JsonProperty("product_id")
    public String productId;

    @JsonProperty("send_invite")
    public Boolean sendInvite;

    @JsonProperty("business_id")
    public String businessId;

    //@NotNull
    @JsonProperty("business_name")
    public ApiText businessName;

    @Pattern(regexp = "^(freelancer|company|homemaker)$", groups = {OnUpdateLead.class, OnCreateLeadValidation.class}, message =
            "Only 'freelancer||company||homemaker' are allowed in " +
                    "business type")
    @JsonProperty("business_type")
    public String businessType;

    //@NotNull
//    @NotNull(groups = {OnCreateLeadValidation.class}, message = "country_code required")
    @JsonProperty("country_code")
    public String country;

    @JsonProperty("is_licensed")
    public Boolean isLicensed;

    public ApiBrand brand;

    @JsonProperty("metadata")
    public HashMap<String, String> metaData;

    public String note;

    public List<company.tap.commondependencies.ApiModels.ApiLead.Note> notes;

    @JsonProperty("lead_by")
    public LeadBy leadBy;

    public Invite invite;

    @JsonProperty("associate_account")
    public Boolean associateAccount;

    @JsonProperty("step_name")
    public String stepName;

    @JsonProperty("segment_type")
    public String segmentType;
    @JsonProperty("license_number")
    public String licenseNumber;
    @Pattern(regexp = "^(commercial_registration|freelance)$", groups = {OnUpdateLead.class, OnCreateLeadValidation.class}, message =
            "Only commercial_registration || freelance are allowed ")
    @JsonProperty("license_type")
    public String licenseType;
    @JsonProperty("individual_id")
    public String individualId;
    //    @JsonProperty("identification_id")
//    public String identificationId;
//    @JsonProperty("identification_id_type")
//    @Pattern(regexp = "^(national_id|passport|iqamah|gcc_national_id|civil_id)$", groups = {OnUpdateLead.class},
//            message =
//                    Constants.ErrorMessages.ALLOWED_IDENTIFICATION_TYPE)
//    public String identificationIdType;
//    @JsonProperty("is_identification_verified")
//    public boolean isIdentificationVerified;
    @JsonProperty("date_of_birth")
    public Date dateOfBirth;
    public HashMap<String, Date> steps;
    @JsonProperty("merchant_wallet_id")
    public String merchantWalletId;
    @JsonProperty("is_acknowledged")
    public Boolean isAcknowledged;
    @JsonProperty("terms_conditions_accepted")
    public Boolean termsConditionsAccepted;
    /**
     * entities are used for lead list endpoint
     */
    public List<ApiEntity> entities;
    /**
     * entity is used to give license info in lead
     */
    public ApiEntity entity;
    /**
     * entityActivities is used only in response with license activities pulled from third party services
     */
    @JsonProperty("entity_activities")
    public List<ApiEntity.Activity> entityActivities;
    /**
     * apiBankAccount used for bank response
     */
    @JsonProperty("bank_account")
    public ApiBankAccount apiBankAccount;
    /**
     * deviceInfo used for device authentication
     */
    @JsonProperty("device_info")
    public ApiDevice deviceInfo;
    /**
     * lang is used only while sending notification either email or sms
     */
    @Pattern(regexp = "^(en|ar)$", groups = {OnUpdateLead.class, OnCreateLeadValidation.class}, message = "only en and ar lang allowed")
    @JsonProperty("lang")
    public String lang;

    public Merchant merchant;

    @JsonProperty("board_id")
    public String boardId;

    @JsonProperty("board_info_id")
    public String boardInfoId;

    public String idempotent;

    /**
     * apiVerificationToken is used in ID verification
     */
    @JsonProperty("verification_token")
    public ApiVerificationToken apiVerificationToken;

    @JsonProperty("is_new_individual")
    public boolean isNewIndividual;

    @Valid
    @JsonProperty("identification")
    public Identification identification;

    public Notification notification;
    @JsonProperty("post")
    public Map<String, String> postUrl;

    public List<String> platforms;


    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Note {
        public String message;
        public Date date;
        @JsonProperty("name")
        public String userName;
        @JsonProperty("user_id")
        public String userId;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class LeadBy {
        @JsonProperty("business_name")
        public String businessName;
        @JsonProperty("business_id")
        public String businessId;
        @JsonProperty("name")
        public String userName;
        @JsonProperty("user_id")
        public String userId;

    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Invite {
        public boolean sent;
        @JsonProperty("sent_date")
        public Date sentDate;
        public boolean accepted;
        @JsonProperty("accepted_date")
        public Date acceptedDate;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Merchant {
        public String id;
        @JsonProperty("wallet_id")
        public String walletId;
        /**
         * isAcceptanceAllowed used in response
         */
        @JsonProperty("is_acceptance_allowed")
        public boolean isAcceptanceAllowed;
        /**
         * isPayoutAllowed used in response
         */
        @JsonProperty("is_payout_allowed")
        public boolean isPayoutAllowed;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Identification {
        @JsonProperty("id")
        @NotNull(groups = {OnCreateLeadValidation.class, OnUpdateLead.class}, message = "id required")
        public String idNumber;
        @JsonProperty("issued_country_code")
        @NotNull(groups = {OnCreateLeadValidation.class, OnUpdateLead.class}, message = "issued_country_code required")
        public String issueCountryCode;
        @JsonProperty("type")
        @NotNull(groups = {OnCreateLeadValidation.class, OnUpdateLead.class}, message = "type required")
        @Pattern(regexp = "^(national_id|passport|iqamah|gcc_national_id|civil_id)$", groups = {OnUpdateLead.class, OnCreateLeadValidation.class},
                message =
                        "Only 'national_id||passport||iqamah||gcc_national_id||civil_id' are allowed " +
                                "in " +
                                "identification_id_type")
        public String type;
        @JsonProperty("authentication_id")
        public String authenticationId;
        public String status;
        @JsonProperty("is_verified")
        public Boolean isVerified;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Notification {
        public Boolean email;
    }

}
