/*
 * Copyright (c) 2022. Tap Payments
 * Author: Charan Dommara
 * Created On: 23 9 2022
 */

package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiBoardRequest {

    public Map<String, String> merchant;
    @JsonProperty("brand_id")
    public String brandId;
    @JsonProperty("entity_id")
    public String entityId;
    @JsonProperty("business_id")
    public String businessId;
    public String type;
    @JsonProperty("reference_id")
    public String referenceId;

    public String lang;
    @JsonProperty("device_id")
    public String deviceId;

    @JsonProperty("id_required_only")
    boolean idRequiredOnly =false;
}
