/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.Helpers;

import company.tap.commondependencies.Helpers.IHelper;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.springframework.stereotype.Service;

@Service
class Helper
implements IHelper {
    Helper() {
    }

    @Override
    public String maskString(String strText, int start, int end, char maskChar) throws Exception {
        int maskLength;
        if (strText == null || strText.equals("")) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end > strText.length()) {
            end = strText.length();
        }
        if ((maskLength = (end = strText.length() - end) - start) == 0) {
            return strText;
        }
        return strText.substring(0, start) + String.valueOf(maskChar).repeat(Math.max(0, maskLength)) + strText.substring(start + maskLength);
    }

    @Override
    public String GenerateFingerprint(String data) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] hashInBytes = md.digest(data.getBytes(StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        for (byte b : hashInBytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

