/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.Helpers;

import com.google.common.base.Strings;
import company.tap.commondependencies.ApiModels.ApiText;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Component
public class ObjectConverterHelper {

    public static Map<String, String> convertApiTextToMap(ApiText apiText) {
        if (Objects.isNull(apiText))
            return null;
        Map<String, String> map = new HashMap<>();
        if (!Strings.isNullOrEmpty(apiText.en))
            map.put("en", apiText.en);
        if (!Strings.isNullOrEmpty(apiText.ar))
            map.put("ar", apiText.ar);
        if (!Strings.isNullOrEmpty(apiText.de))
            map.put("de", apiText.de);
        if (!Strings.isNullOrEmpty(apiText.bn))
            map.put("bn", apiText.bn);
        if (!Strings.isNullOrEmpty(apiText.fa))
            map.put("fa", apiText.fa);
        if (!Strings.isNullOrEmpty(apiText.es))
            map.put("es", apiText.es);
        if (!Strings.isNullOrEmpty(apiText.fr))
            map.put("fr", apiText.fr);
        if (!Strings.isNullOrEmpty(apiText.hi))
            map.put("hi", apiText.hi);
        if (!Strings.isNullOrEmpty(apiText.it))
            map.put("it", apiText.it);
        if (!Strings.isNullOrEmpty(apiText.ml))
            map.put("ml", apiText.ml);
        if (!Strings.isNullOrEmpty(apiText.nl))
            map.put("nl", apiText.nl);
        if (!Strings.isNullOrEmpty(apiText.pa))
            map.put("pa", apiText.pa);
        if (!Strings.isNullOrEmpty(apiText.ru))
            map.put("ru", apiText.ru);
        if (!Strings.isNullOrEmpty(apiText.ta))
            map.put("ta", apiText.ta);
        if (!Strings.isNullOrEmpty(apiText.te))
            map.put("te", apiText.te);
        if (!Strings.isNullOrEmpty(apiText.tl))
            map.put("tl", apiText.tl);
        if (!Strings.isNullOrEmpty(apiText.tr))
            map.put("tr", apiText.tr);
        if (!Strings.isNullOrEmpty(apiText.ur))
            map.put("ur", apiText.ur);
        if (!Strings.isNullOrEmpty(apiText.zh))
            map.put("zh", apiText.zh);
        return map;
    }
}
