/*
 * Copyright (c) 2022. Tap Payments
 * Author: Charan Dommara
 * Created On: 24 2 2022
 */

package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiVerification {
    private Long created;
    private Long updated;
    private String status;
    @JsonProperty("individual_id")
    private String individualId;
    @JsonProperty("identification_id")
    private String identificationId;
    private List<Verification> verifications;

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Verification {
        @JsonProperty("service_name")
        private String serviceName;
        @JsonProperty("service_type")
        private String serviceType;
        private String response;
        @JsonProperty("request_sent_at")
        private Date requestSentAt;
        @JsonProperty("response_status_code")
        private String responseStatusCode;
        @JsonProperty("is_mobile_owner")
        private Boolean isMobileOwner;
        private String otp;
        @JsonProperty("is_otp_verified")
        private Boolean isOtpVerified;
        @JsonProperty("verified_at")
        private Date verifiedAt;
        private String status;
        @JsonProperty("lead_id")
        private String leadId;
    }
}
