/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.LinkedHashMap;
import java.util.Map;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({"id", "status", "created", "object", "live_mode", "api_version", "feature_version", "name",})
public class ApiTerminal extends ApiBaseModel {
    @JsonProperty("name")
    public Map<String, String> name;
    @JsonProperty("branch")
    public ApiBranch apiBranch;
    @JsonProperty("merchant")
    public ApiMerchant apiMerchant;
    @JsonProperty("acceptance")
    public ApiAcceptance apiAcceptance;
    @JsonProperty("authorizes")
    public LastTransactions authorizes;
    @JsonProperty("charges")
    public LastTransactions charges;
    @JsonProperty("refunds")
    public LastTransactions refunds;
    @JsonProperty("wallet")
    public ApiWallet apiWallet;
    @JsonProperty("virtual")
    public boolean isVirtual;
    @JsonProperty("operator")
    public ApiOperator apiOperator;
    @JsonProperty("acceptance_status")
    public String acceptanceStatus;
    @JsonProperty("acceptance_channel")
    public ApiBrand.ChannelService channelService;
    @JsonProperty("data_status")
    public ApiTerminalData dataStatus;
    @JsonProperty("data_verification")
    public ApiTerminalData dataVerification;
    @JsonProperty("data_state")
    public String dataState;
    @JsonProperty("brand")
    public ApiBrand apiBrand;
    @JsonProperty("control_by")
    public String controlBy;
    @JsonProperty("payout_status")
    public String payoutStatus;
    @JsonProperty("acceptance_status_control")
    public String acceptanceStatusControl;

    @JsonIgnore
    private Map<String, ApiCreatedBy> createdBy = new LinkedHashMap<>();

    @JsonAnyGetter
    public Map<String, ApiCreatedBy> getCreatedBy() {
        return createdBy;
    }

    @JsonAnySetter
    public void setCreatedBy(String key, Object value) {
        if (value instanceof String || value instanceof Boolean) return;
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.createdBy.put(key, mapper.convertValue(value, ApiCreatedBy.class));
        } catch (Exception e) {
            //ignore exception
        }
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class LastTransactions {
        @JsonProperty("last_transaction")
        public Long lastTransaction;
        @JsonProperty("status")
        public String status;
        @JsonProperty("status_message")
        public String statusMessage;
        @JsonProperty("flag")
        public Boolean isFlag;
    }

}
