package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiBrand extends ApiBaseModel {
	@NotNull
	public ApiText name;
	public List<ApiBrand.Sector> sectors;
	public String website;
	public List<String> social;
	public String logo;
	public ApiContent content;
	public List<ApiBrand.Activity> activities;
	@JsonProperty("channel_services")
	public List<ApiBrand.ChannelService> channelServices;
	public ApiBrand.Operation operations;
	public ApiBrand.Segment segment;
	public List<String> term;
	public List<ApiBrand.Terms> terms;
	public List<String> branches;
	@JsonProperty("physical_store_available")
	public Boolean physicalStoreAvailable;
	/**
	 * createdAt used for legacy Migration
	 */
	@JsonProperty("created_at")
	public String createdAt;
	
	@JsonProperty("data_status")
	public ApiBrandData<String> dataStatus;
	
	@JsonProperty("data_verification")
	public ApiBrandData<Map<String, String>> dataVerification;
	@JsonProperty("data_state")
	public String dataState;
	
	@JsonProperty("term_by")
	public String termBy;
	
	@JsonProperty("term_by_info")
	public ApiAcceptedBy termByInfo;
	
	@JsonProperty("business_volume")
	public ApiBrand.BusinessVolume businessVolume;
	
	public List<ApiFlag> flags;
	
	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class ChannelService{
		public String id;
		public String code;
		public ApiText name;
		public String address;
		public List<String> addresses;
		public String logo;
		@JsonProperty("terminal_id")
		public String terminalId;
		public List<ApiBrand.Sub> sub;
	}
	
	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Sub{
		public String id;
		public String code;
		public ApiText name;
		public String logo;
		public String address;
		@JsonProperty("terminal_id")
		public String terminalId;
	}
	
	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Sector{
		public String id;
		public String code;
		public ApiText name;
	}
	
	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Activity{
		public String id;
		public String code;
		public ApiText name;
		@JsonProperty("isic_code")
		public String isicCode;
		@JsonProperty("mcc_value")
		private ApiMcc mccValue;
	}

	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Operation{
		@JsonProperty("start_date")
		public String startDate;
		public Sales sales;
		@JsonProperty("customer_base")
		public ApiBrand.CustomerBase customerBase;
	}

	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Sales{
		public String id;
		public String code;
		public ApiText name;
		public String period;
		public String currency;
		public Range range;
		public List<SubRange> sub;
	}
	
	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Range{
		public long from;
		public long to;
	}
	
	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class SubRange{
		public String id;
		public ApiText name;
		public Range range;
	}

	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class CustomerBase{
		public String id;
		public String code;
		public ApiText name;
		public String period;
		public Range range;
		public List<SubRange> sub;
		public List<Location> locations;
	}
	
	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Location{
		public String id;
		public String code;
		public ApiText name;
	}

	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Terms{
		public String term;
		public boolean agree;
		@JsonProperty("agreed_at")
		public long agreedAt;
	}
	
	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Segment {
		public SegmentType type;
		public SegmentTeam team;
		public SegmentSale sale;
		@JsonProperty("location_type")
		public SegmentType locationType;
		@JsonProperty("profit_type")
		public SegmentType profitType;
		@JsonProperty("tech_type")
		public SegmentType techType;
	}

	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class SegmentType{
		public String id;
		public ApiText name;
	}

	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class SegmentTeam extends SegmentType{
		public String team;
	}

	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class SegmentSale extends SegmentType{
		public String sale;
	}
	
	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class BusinessVolume{
		public String id;
		public Indicator indicator;
		public List<Map<String,String>> name;
	}
	
	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Indicator{
		public String type;
	}
}
