package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiBankAccount extends ApiBaseModel {
    @NotEmpty(message = "Please provide a iban;")
    public String iban;
    public String account_number;
    public String swift_code;
    @JsonProperty("bank_name")
    public String bankName;
    @JsonProperty("beneficiary_name")
    public String beneficiaryName;
    @JsonProperty("bank_statement_file_id")
    public String bankStatementFileId;
    @JsonProperty("is_acknowledged")
    public Boolean isAcknowledged;
    @JsonProperty("acknowledged_by")
    public String acknowledgedBy;
    @JsonProperty("acknowledged_by_info")
    public ApiAcceptedBy acknowledgedByInfo;
    @JsonProperty("wallet_id")
    public String walletId;
    @JsonProperty("bank_id")
    public String bankId;
    @JsonProperty("created_at")
    public String createdAt;
    @JsonProperty("data_status")
	public ApiBankAccountData dataStatus;
	@JsonProperty("data_verification")
	public ApiBankAccountData dataVerification;
    public ApiDocuments document;
    @JsonProperty("data_state")
    public String dataState;
    public List<ApiFlag> flags;


}
