package company.tap.commondependencies.Headers;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import company.tap.commondependencies.ApiModels.ApiHeaders;
import company.tap.commondependencies.ApiModels.Session;
import company.tap.commondependencies.Constants.CommonConstants;
import company.tap.commondependencies.Constants.CommonErrorMessages;
import company.tap.commondependencies.Errors.Errors;
import company.tap.commondependencies.Errors.IErrorServices;
import company.tap.commondependencies.Helpers.ObjMapper;
import company.tap.commondependencies.Helpers.RestAPI;
import company.tap.commondependencies.Operator.IOperatorHelper;
import company.tap.commondependencies.Operator.PrivateOperator;
import company.tap.commondependencies.exceptions.UnauthorizedException;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;

@Log4j2
@Service
class HeaderService implements IHeaderService {

    final
    IErrorServices _errorServices;

    final
    IOperatorHelper iOperatorHelper;

    public HeaderService(IErrorServices _errorServices, IOperatorHelper iOperatorHelper) {
        this._errorServices = _errorServices;
        this.iOperatorHelper = iOperatorHelper;
    }

    public ApiHeaders GetHeaderData(HttpHeaders request) {
        try {
            return GetHeaderData(request, false);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ApiHeaders GetHeaderData(HttpHeaders request, boolean operator) {
        try {
            log.info(request);
            ApiHeaders headers = new ApiHeaders();
            String auth = request.getFirst("Authorization");
            if (auth == null)
                return null;
            auth = auth.replace("'", "");
            String[] au = auth.split(" ");
            if (au.length >= 2)
                headers.authorization = au[1];
            else
                headers.authorization = auth;
            String langCode = request.getFirst("lang_code");
            if (langCode != null)
                langCode = langCode.replace("'", "");
            else
                langCode = "EN";
            headers.lang_code = langCode;
            String liveMode = request.getFirst("livemode");
            if (liveMode == null)
                return null;
            liveMode = liveMode.replace("'", "");
            headers.live_mode = liveMode.equals("true");
            String merchantId = request.getFirst("merchant_id");
            if (merchantId == null)
                return null;
            merchantId = merchantId.replace("'", "");
            headers.merchant_id = merchantId;
            if (merchantId.equals("1300"))
                headers.isTap = true;
            String sessionToken = request.getFirst("session_token");
            if (sessionToken == null)
                return null;
            sessionToken = sessionToken.replace("'", "");
            headers.session_token = sessionToken;
            String permissions = request.getFirst("permissions");
            if (permissions != null) {
                permissions = permissions.replace("'", "\"");
                log.info(permissions);
                if (permissions.contains("["))
                    headers.permissions = ObjMapper.getInstance().readValue(permissions, String[].class);
                headers.permission = permissions;
            }
            String channelId = request.getFirst("channel_id");
            if (channelId != null)
                channelId = channelId.replace("'", "");
            headers.channel_id = channelId;
            String networkId = request.getFirst("network_id");
            if (networkId != null)
                networkId = networkId.replace("'", "");
            headers.network_id = networkId;
            String terminalId = request.getFirst("terminal_id");
            if (terminalId != null)
                terminalId = terminalId.replace("'", "");
            headers.terminal_id = terminalId;
            String customer_checked = request.getFirst("customer_checked");
            headers.customer_checked = customer_checked != null && customer_checked.equals("true");
            headers.appAuthorization = request.getFirst("app_authorization");
            if (operator) {
                String operatorId = request.getFirst("operatorId");
                if (operatorId == null) {
                    PrivateOperator privateOperator = iOperatorHelper.GetOperatorInfoByKey(headers.authorization);
                    if (privateOperator == null)
                        return null;
                    if (!privateOperator.getStatus().equalsIgnoreCase(CommonConstants.Status.Active))
                        throw new UnauthorizedException(CommonErrorMessages.UNAUTHORIZED_OPERATOR_IN_ACTIVE);
                    headers.operatorId = privateOperator.operatorId;
                    headers.businessId = privateOperator.businessId;
                    headers.segmentId = privateOperator.segmentId;
                    headers.productId = privateOperator.productId;
                    request.set("operatorId", privateOperator.operatorId);
                    request.set("businessId", privateOperator.businessId);
                    request.set("segmentId", privateOperator.segmentId);
                    request.set("productId", privateOperator.productId);
                    return headers;
                }
                headers.operatorId = operatorId;
                String businessId = request.getFirst("businessId");
                headers.businessId = businessId;
                String segmentId = request.getFirst("segmentId");
                if (segmentId != null && segmentId.isBlank())
                    headers.segmentId = null;
                else
                    headers.segmentId = segmentId;
                headers.productId = request.getFirst("productId");
            }
            return headers;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    ApiHeaders GetSessionHeaderData(String Session, String JWTSecretKey) {
        byte[] byteSecret = JWTSecretKey.getBytes(StandardCharsets.US_ASCII);
        String Ses;
        try {
            new ApiHeaders();
            Algorithm algorithm = Algorithm.HMAC256(byteSecret);
            JWTVerifier verifier = JWT.require(algorithm).acceptLeeway(1).build(); // Reusable verifier instance
            DecodedJWT jwt = verifier.verify(Session);
            byte[] bs = Base64.getDecoder().decode(jwt.getPayload());
            Ses = new String(bs);
            return ObjMapper.getInstance().readValue(Ses, ApiHeaders.class);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
            // don't trust the JWT!
        }
    }

    public ResponseEntity<Object> ValidateHeaders(HttpHeaders httpHeaders, boolean tap, String JWTSecretKey) {
        ApiHeaders headers = GetHeaderData(httpHeaders);
        if (headers != null) {
            ApiHeaders sessionHead = GetSessionHeaderData(headers.session_token, JWTSecretKey);
            return getObjectResponseEntity(tap, headers, sessionHead);
        } else {
            return _errorServices.Error(Errors.Headers_values_missing.getCode(),
                    Errors.Headers_values_missing.toString(), "Header values are missing", HttpStatus.BAD_REQUEST);
        }
    }

    private ResponseEntity<Object> getObjectResponseEntity(boolean tap, ApiHeaders headers, ApiHeaders sessionHead) {
        if (sessionHead == null) {
            return _errorServices.Error(Errors.Invalid_API_Key.getCode(), Errors.Invalid_API_Key.toString(),
                    "Invalid session token", HttpStatus.UNAUTHORIZED);
        }
        if (!sessionHead.api_key.equals(headers.authorization)) {
            return _errorServices.Error(Errors.Invalid_API_Key.getCode(), Errors.Invalid_API_Key.toString(),
                    "Api key doesnt match with session token", HttpStatus.UNAUTHORIZED);
        }
        if (!sessionHead.merchant_id.equals(headers.merchant_id)) {
            return _errorServices.Error(Errors.Invalid_API_Key.getCode(), Errors.Invalid_API_Key.toString(),
                    "Api key doesnt match with merchant id", HttpStatus.UNAUTHORIZED);
        }
        if (tap) {
            if (!sessionHead.merchant_id.equals("1300")) {
                return _errorServices.Error(Errors.Invalid_API_Key.getCode(), Errors.Invalid_API_Key.toString(),
                        "Api key is not authorized", HttpStatus.UNAUTHORIZED);
            }
        }
        return null;
    }

    @Override
    public ResponseEntity<Object> ValidateHeaders(HttpHeaders httpHeaders, boolean tap) {
        ApiHeaders headers = GetHeaderData(httpHeaders);
        if (headers != null) {
            ApiHeaders sessionHead = GetSessionHeaderData(headers.session_token, "vaKvjbBUSNgehrmMJsNJVBcKwVLHKKzb");
            return getObjectResponseEntity(tap, headers, sessionHead);
        } else {
            return _errorServices.Error(Errors.Headers_values_missing.getCode(),
                    Errors.Headers_values_missing.toString(), "Header values are missing", HttpStatus.BAD_REQUEST);
        }
    }

    @Override
    public ResponseEntity<Object> ValidateHeaders(HttpHeaders httpHeaders, boolean tap, boolean operator) {
        ApiHeaders headers = GetHeaderData(httpHeaders, true);
        if (headers != null) {
            ApiHeaders sessionHead = GetSessionHeaderData(headers.session_token, "vaKvjbBUSNgehrmMJsNJVBcKwVLHKKzb");
            return getObjectResponseEntity(tap, headers, sessionHead);
        } else {
            return _errorServices.Error(Errors.Headers_values_missing.getCode(),
                    Errors.Headers_values_missing.toString(), "Header values are missing", HttpStatus.BAD_REQUEST);
        }
    }

    private Session getLoginSession(String apiKey) {
        try {
            HttpHeaders headersCA = new HttpHeaders();
            headersCA.setAccept(Arrays.asList(MediaType.APPLICATION_FORM_URLENCODED));
            MultiValueMap<String, Object> body = new LinkedMultiValueMap<>();
            body.add("key", apiKey);
            HttpEntity<MultiValueMap<String, Object>> entityToken = new HttpEntity<>(body, headersCA);
            return RestAPI.getInstance()
                    .exchange("https://api.tap.company/v2/gologin/session", HttpMethod.POST, entityToken, Session.class)
                    .getBody();
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    public HttpHeaders getSessionHeaders(String apiKey) {
        Session session = getLoginSession(apiKey);
        if (session != null && session.status.equals("success")) {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.setContentType(MediaType.APPLICATION_JSON);
            httpHeaders.set("merchant_id", session.data.merchant_id);
            httpHeaders.set("live_mode", String.valueOf(session.data.live_mode));
            httpHeaders.set("livemode", String.valueOf(session.data.live_mode));
            httpHeaders.set("session_token", session.data.session_token);
            httpHeaders.set("Authorization", apiKey);
            return httpHeaders;
        }
        return null;
    }

}
