package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({"id","status","created","object","live_mode","api_version","feature_version","name",
		"business_id","business_entity_id","developer_id","user_id","wallet_id","is_merchant"})
public class ApiOperator extends ApiBaseModel {
	public segment segment;
	public String business_entity_id;
	@NotNull
	public String developer_id;
	public String user_id;
	public List<ReqBrand> brands;
	@NotNull(message = "Please provide a wallet_id")
	public String wallet_id;
	@NotNull(message = "Please provide a name")
	public String name;
	public String terminal_id;
	@JsonProperty("is_merchant")
	public boolean is_merchant;
	public String platform;
	public ApiOperatorToolkit toolkit;
	public ApiOperatorApp app;
	public goLoginApiKeys api_credentials;
	@JsonProperty("product_id")
	public String productId;

	@Data
	@NoArgsConstructor
	public class segment {
		public String id;
		public String type;
	}

}
