package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.*;

import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({"id", "status", "created", "object", "live_mode", "api_version", "feature_version", "display_name",
        "business_id", "business_entity_id", "brand_id", "branch_id", "wallet_id", "base_currency"})
public class ApiMerchant extends ApiBaseModel {
    public String display_name;
    @NotEmpty(message = "Please provide a business_entity_id;")
    public String business_entity_id;
    public String brand_id;
    public String branch_id;
    public String wallet_id;
    public String base_currency;
    public List<String> charge_currenices;
    public ApiWallet wallets;
    public ApiBankAccount bank_account;

    public String settlement_by;
    public ApiSettlement settlement; //Added on 27OCT
    public String country;
    public String email; //Added on 19DEC21
    @JsonProperty("signed_in_entity")
    public ApiEntityResponse.ApiSignedInEntity apiSigneInEntity;
    @JsonProperty("is_acceptance_allowed")
    public Boolean isAcceptanceAllowed;
    @JsonProperty("is_payout_allowed")
    public Boolean isPayoutAllowed;
    @JsonProperty("legacy_id")
    public String legacyId;
    @JsonProperty("marketplace")
    public Boolean isMarketPlace;
    @JsonProperty("marketplace_id")
    public String marketPlaceId;
    public ApiOperator operator;
    @JsonProperty("post")
    public Map<String, String> postUrl;
    @JsonProperty("metadata")
    public Map<String, String> metadata;

    @JsonProperty("data_status")
    public ApiMerchantData dataStatus;

    @JsonProperty("data_verification")
    public ApiMerchantData dataVerification;

    @JsonProperty("data_state")
    public String dataState;
    @JsonIgnore
    private Map<String, ApiCreatedBy> createdBy = new LinkedHashMap<>();
    @JsonProperty("flags")
    public List<ApiFlag> flags;
    @JsonProperty("terminal_id")
    public String terminalId;

    @JsonAnyGetter
    public Map<String, ApiCreatedBy> getCreatedBy() {
        return createdBy;
    }

    @JsonAnySetter
    public void setCreatedBy(String key, Object value) {
        if (value instanceof String || value instanceof Boolean) return;
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.createdBy.put(key, mapper.convertValue(value, ApiCreatedBy.class));
        } catch (Exception e) {
            //ignore exception
        }
    }

    @JsonProperty("payout_status")
    public String getPayoutStatus() {
        if (Boolean.TRUE.equals(isPayoutAllowed))
            return "enabled";
        return "disabled";
    }

    @JsonProperty("acceptance_status")
    public String getAcceptanceStatus() {
        if (Boolean.TRUE.equals(isAcceptanceAllowed))
            return "enabled";
        return "disabled";
    }

}
