package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.List;
import java.util.Map;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({"status", "auth_token", "auth_type", "data_token", "auth_session", "device_token", "lead_id",
        "connections"})
public class ApiAuth extends ApiBaseModel {

    /**
     * dataToken - can contain email mobile and authType data encrypted using RSA
     * authToken - returned and accepted authSession - on success session will be
     * returned authType - type of authentication success - Auth status
     */

    @JsonProperty("data_token")
    public String dataToken;

    @JsonProperty("auth_token")
    public String authToken;

    @JsonProperty("auth_session")
    public String authSession;

    @JsonProperty("auth_type")
    public Integer authType;

    @JsonProperty("lead_id")
    public String leadId;

    public ApiConnections connections;

    @JsonProperty("device_info")
    public ApiDevice deviceInfo;

    @JsonProperty("device_token")
    public String deviceToken;

    @JsonProperty("remember_me")
    public Boolean rememberMe;

    @JsonProperty("keepme_signedin")
    public Boolean keepMeSignedIn;

    @JsonProperty("new_user")
    public Boolean newUser;

    @JsonProperty("scopes")
    public List<String> scopes;

    @JsonProperty("api_credentials")
    public goLoginApiKeys apiCredentials;

    @JsonProperty("signup_token")
    public String signupToken;

    @JsonProperty("sign_in")
    public Boolean signIn;

    @JsonProperty("individual_id")
    public String individualId;

    @JsonProperty("individual_country_code")
    public String individualCountryCode;

    @JsonProperty("is_tap_user")
    public Boolean isTapUser;

    @JsonProperty("service_name")
    public String serviceName;

    @JsonProperty("auth_info")
    public Map<String, String> authInfo;


    @JsonProperty("email_url")
    public String emailUrl;

    public String lang;

    /**
     * isVerified used for response
     */
    @JsonProperty("is_verified")
    public Boolean isVerified;

    /**
     * authData contain data received for auth
     */
    @JsonProperty("auth_data")
    public Map<String, Object> authData;

    /**
     * verifiedSata contain data received from third party authentication
     */
    @JsonProperty("verified_data")
    public String verifiedData;

    /**
     * isLead is used to create lead on verify
     */
    @JsonProperty("is_lead")
    public Boolean isLead;

}
