/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.ThridPartyApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import company.tap.commondependencies.ApiModels.ApiBaseModel;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiFreelanceSa extends ApiBaseModel {
    private UserCertificatesResult result;

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class UserCertificatesResult {
        private String englishName;
        private String nationalId;
        private String arabicName;
        private Date nationalIdExpiryDate;
        private String status;
        private Date revokedAt;
        private Date issueAt;
        private Date canceledAt;
        private List<UserCertificates> certificates;
    }

    @Data
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    @NoArgsConstructor
    public static class UserCertificates {
        private Date expiryDate;
        private String number;
        private String status;
        private Date revokedAt;
        private Date issueDate;
        private Speciality speciality;
        private Date canceledAt;

        @Data
        @NoArgsConstructor
        public static class Speciality {
            private String code;
            private String name;
            private Category category;
        }

        @Data
        @NoArgsConstructor
        public static class Category {
            private String name;
            private String nameEn;
        }
    }
}
