package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.util.HashMap;
import java.util.List;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiWallet extends ApiBaseModel {
    public String base_currency;
    public String country;
    public String settlement_by;
    public boolean primary_wallet;
    @NotEmpty(message = "Please provide a business_entity_id")
    public String business_entity_id;
    @JsonProperty("is_merchant")
    public boolean is_merchant;
    public List<ReqBrand> brands;
    public ApiBankAccount bank_account;
    @JsonProperty("is_non_resident")
    public boolean isNonResident;
    public ApiSettlement settlement; //Added on 27OCT
    @JsonProperty("balance")
    public HashMap<String, Object> balance;
    @JsonProperty("segment_id")
    public String segmentId;
    @JsonProperty("created_by_segment_id")
    public String createdBySegmentId;
    @JsonProperty("customer_id")
    public String customerId;
    @NotEmpty(message = "Please provide a wallet_name")
    public String wallet_name;
    public String email; //Added on 19DEC21
    @JsonProperty("payout_status")
    public String payoutStatus;
    @JsonProperty("is_transaction_available")
    public Boolean isTransactionAvailable;
    @JsonProperty("last_transaction_created")
    public Long lastTransactionCreated;
}
