/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({"id", "status", "created", "object", "live_mode", "api_version", "feature_version", "name",})
public class ApiTerminal extends ApiBaseModel {
    @JsonProperty("name")
    public Map<String, String> name;
    @JsonProperty("branch")
    public ApiBranch apiBranch;
    @JsonProperty("merchant")
    public ApiMerchant apiMerchant;
    @JsonProperty("acceptance")
    public ApiAcceptance apiAcceptance;
    @JsonProperty("authorizes")
    public LastTransactions authorizes;
    @JsonProperty("charges")
    public LastTransactions charges;
    @JsonProperty("refunds")
    public LastTransactions refunds;


    @Data
    @NoArgsConstructor
    public static class LastTransactions {
        @JsonProperty("last_transaction")
        public Long lastTransaction;
        @JsonProperty("status")
        public String status;
        @JsonProperty("status_message")
        public String statusMessage;
        @JsonProperty("flag")
        public Boolean isFlag;
    }

}
