package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiTax {
    public String id;
    public String name;
    public String description;
    public TaxRate rate;
    @JsonProperty("merchant_id")
    public String merchantId;

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public class TaxRate {
        public String type;
        public Double value;
    }
}
