/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiAcceptance extends ApiBaseModel {
    @JsonProperty("currencies")
    public List<String> currencies;
    @JsonProperty("card_based")
    public CardBased cardBased;
    @JsonProperty("alternate_based")
    public AlternateBased alternateBased;
    @JsonProperty("controls")
    public Controls controls;

    @Data
    @NoArgsConstructor
    public static class AlternateBased {
        @JsonProperty("payment_methods")
        public List<String> paymentMethods;
    }

    @Data
    @NoArgsConstructor
    public static class CardBased {
        @JsonProperty("payment_methods")
        public List<String> paymentMethods;
        @JsonProperty("device_payments")
        public List<String> devicePayments;
        @JsonProperty("express_payments")
        public List<String> expressPayments;
    }

    @Data
    @NoArgsConstructor
    public static class Controls {
        @JsonProperty("id")
        public String id;
        @JsonProperty("matrices")
        public List<Matrices> matrices;
    }

    @Data
    @NoArgsConstructor
    public static class Matrices {
        @JsonProperty("id")
        public String id;
    }
}
