/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.goSellModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import company.tap.commondependencies.ApiModels.*;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class goSellMigration {
    public int response_code;
    public String response_message;
    public String status;
    public boolean transfer;
    public String access_token;
    public String master_segment_type;
    public boolean master_is_segment;
    public boolean is_destination;
    public String master_account_id;
    public String account_type;
    public ApiBankAccount bank_account;
    public Brand brand;
    public ApiEntity entity;
    public Individual individual;


    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Brand {
        public ApiText name;
        public ApiBrand.Sector sector;
        public String logo;
        public ChannelServices channel_services;
        public ApiBrand.Operation operations;
        public ApiBrand.Segment segment;
        public Map<String, Boolean> terms;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public class ChannelServices {
        public String website;
        public String instagram;
        public String twitter;
        public String linkedin;
        public String android;
        public String ios;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public class Individual {
        @JsonProperty("names")
        public Map<String, ApiContactName> names;
        public ApiPrimaryContact contact;
        public String nationality;
        public String gender;
        public Birth birth;
        public Identification identification;
        public Map<String, Verification> verification;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public class Birth {
        public String date;
        public String city;
        public String country;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public class Identification {
        public String id;
        public String type;
        public String expiry;
        @JsonProperty("id_front_copy_url")
        public String idFrontCopyUrl;
        @JsonProperty("id_back_copy_url")
        public String idBackCopyUrl;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public class Verification {
        @JsonProperty("is_verified")
        public boolean isVerified;
        @JsonProperty("verified_at")
        public long verifiedAt;
        @JsonProperty("verified_by")
        public String verifiedBy;
        public String type;
    }
}
