package company.tap.commondependencies.Helpers;

import org.springframework.stereotype.Service;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

@Service
class Helper implements IHelper {
    public String maskString(String strText, int start, int end, char maskChar)
            throws Exception {
        if (strText == null || strText.equals(""))
            return "";
        if (start < 0)
            start = 0;
        if (end > strText.length())
            end = strText.length();
        end = strText.length() - end;
        int maskLength = end - start;
        if (maskLength == 0)
            return strText;
        return strText.substring(0, start)
                + String.valueOf(maskChar).repeat(Math.max(0, maskLength))
                + strText.substring(start + maskLength);
    }

    public String GenerateFingerprint(String data) throws Exception {

        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] hashInBytes = md.digest(data.getBytes(StandardCharsets.UTF_8));

        // bytes to hex
        StringBuilder sb = new StringBuilder();
        for (byte b : hashInBytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}
