package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiEntity extends ApiBaseModel {
	
	@NotNull
	public ApiText legal_name;
	public boolean is_licensed;
	public String license_number;
	public boolean not_for_profit;
	@NotNull
	public String country;
	public String settlement_by;
	public List<ApiDocuments> documents;
	public List<ApiWallet> wallets;
	public List<ApiBranch> branches;
	public ApiBankAccount bank_account; //Added on 07OCT as goSell create account requires iban
	public ApiOperator operator; // Added to return default operator
	public List<ApiBankAccount> bank_accounts;
  }
