/*
 * Copyright (c) 2022. Tap Payments
 * Author: Charan Dommara
 * Created On: 21 9 2022
 */

package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiVerificationToken extends ApiBaseModel {

    @JsonProperty("verification_by")
    public verification verification;
    @JsonProperty("verify_token")
    public String verifyToken;
    @JsonProperty("official_name")
    public OfficialName officialName;
    @JsonProperty("new_user")
    public Boolean newUser;

    @JsonProperty("step_name")
    public String stepName;
    @JsonProperty("signup_token")
    public String signupToken;
    @JsonProperty("board_info_id")
    public String boardInfoId;

    @JsonProperty("country_code")
    public String countryCode;

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class verification {
        @JsonProperty("service_name")
        public String serviceName;
        public String status;
        public String message;
        public String type;
        @JsonProperty("is_otp_verified")
        public boolean isOtpVerified;
        @JsonProperty("sent_to")
        public String  sentTo;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class OfficialName {
        @JsonProperty("first_name")
        public String firstName;
        @JsonProperty("last_name")
        public String lastName;
        @JsonProperty("second_name")
        public String secondName;
        @JsonProperty("third_name")
        public String thirdName;
    }
}
