/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.ISO8583.enums;

public class ProcessCodes {
    public enum ATC {

        Default("00"),
        SavingAccount("10"),
        CheckingAccount("20"),
        CreditCardAccount("30");

        private final String code;

        ATC(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }
    }

    public enum TTC_100 {

        Authorization("00"),
        AuthorizationVoid("02"),
        Refund_Return("20"),
        Refund_Return_void("22"),
        BalanceInquiry("30");

        private final String code;

        TTC_100(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }
    }

    public enum TTC_200 {
        Purchase("00"),
        Withdrawal("01"),
        Void("02"),
        Refund_Return("20"),
        Payment_Deposit_Refresh("21"),
        AccountTransfer("40"),
        PurchaseAdvise("00"),
        Refund_Return_advise("20");

        private final String code;

        TTC_200(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }
    }
}
