package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Pattern;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiLead extends ApiBaseModel {

    //@NotNull
    public ApiContactName name;

    //@NotNull
    @JsonProperty("contact")
    public ApiPrimaryContact contactInfo;

    public String nationality;

    @JsonProperty("product_id")
    public String productId;

    @JsonProperty("send_invite")
    public Boolean sendInvite;

    @JsonProperty("business_id")
    public String businessId;

    //@NotNull
    @JsonProperty("business_name")
    public ApiText businessName;

    @JsonProperty("business_type")
    public String businessType;

    //@NotNull
    @JsonProperty("country_code")
    public String country;

    @JsonProperty("is_licensed")
    public Boolean isLicensed;

    public ApiBrand brand;

    @JsonProperty("metadata")
    public HashMap<String, String> metaData;

    public String note;

    public List<Note> notes;

    @JsonProperty("lead_by")
    public LeadBy leadBy;

    public Invite invite;

    @JsonProperty("associate_account")
    public Boolean associateAccount;

    @JsonProperty("step_name")
    public String stepName;

    @JsonProperty("segment_type")
    public String segmentType;
    @JsonProperty("license_number")
    public String licenseNumber;
    @JsonProperty("license_type")
    public String licenseType;
    @JsonProperty("individual_id")
    public String individualId;
    //    @JsonProperty("identification_id")
//    public String identificationId;
//    @JsonProperty("identification_id_type")
//    public String identificationIdType;
    @JsonProperty("date_of_birth")
    public Date dateOfBirth;
    public HashMap<String, Date> steps;
    @JsonProperty("merchant_wallet_id")
    public String merchantWalletId;
    @JsonProperty("is_acknowledged")
    public Boolean isAcknowledged;
    @JsonProperty("terms_conditions_accepted")
    public Boolean termsConditionsAccepted;
    /**
     * entities are used for lead list endpoint
     */
    public List<ApiEntity> entities;
    /**
     * entity is used to give license info in lead
     */
    public ApiEntity entity;
    /**
     * entityActivities is used only in response with license activities pulled from third party services
     */
    @JsonProperty("entity_activities")
    public List<ApiEntity.Activity> entityActivities;
//    /**
//     * flows used for sending flow status and token url in response
//     */
//    public List<FlowEmailUrl> flows;
    /**
     * apiBankAccount used for bank response
     */
    @JsonProperty("bank_account")
    public ApiBankAccount apiBankAccount;
    /**
     * deviceInfo used for device authentication
     */
    @JsonProperty("device_info")
    public ApiDevice deviceInfo;

    @JsonProperty("lang")
    public String lang;

    public Merchant merchant;

    @JsonProperty("board_id")
    public String boardId;

    @JsonProperty("board_info_id")
    public String boardInfoId;
    /**
     * apiVerificationToken is used in ID verification
     */
    @JsonProperty("verification_token")
    public ApiVerificationToken apiVerificationToken;

    @JsonProperty("is_new_individual")
    public boolean isNewIndividual;

    @JsonProperty("identification")
    public Identification identification;

    public Notification notification;
    @JsonProperty("post")
    public Map<String, String> postUrl;


//    @Data
//    @NoArgsConstructor
//    @JsonInclude(value = JsonInclude.Include.NON_NULL)
//    public static class FlowEmailUrl {
//        public String name;
//        public String url;
//        public String status;
//        @JsonProperty("email_token")
//        public String emailToken;
//    }


    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Note {
        public String message;
        public Date date;
        @JsonProperty("name")
        public String userName;
        @JsonProperty("user_id")
        public String userId;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class LeadBy {
        @JsonProperty("business_name")
        public String businessName;
        @JsonProperty("business_id")
        public String businessId;
        @JsonProperty("name")
        public String userName;
        @JsonProperty("user_id")
        public String userId;

    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public class Invite {
        public boolean sent;
        @JsonProperty("sent_date")
        public Date sentDate;
        public boolean accepted;
        @JsonProperty("accepted_date")
        public Date acceptedDate;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Identification {
        @JsonProperty("id")
        public String id;
        @JsonProperty("issued_country_code")
        public String issueCountryCode;
        @JsonProperty("type")
        public String type;
        @JsonProperty("authentication_id")
        public String authenticationId;
        public String status;
        @JsonProperty("is_verified")
        public Boolean isVerified;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Merchant {
        public String id;
        @JsonProperty("wallet_id")
        public String walletId;
        /**
         * isAcceptanceAllowed used in response
         */
        @JsonProperty("is_acceptance_allowed")
        public boolean isAcceptanceAllowed;
        /**
         * isPayoutAllowed used in response
         */
        @JsonProperty("is_payout_allowed")
        public boolean isPayoutAllowed;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Notification {
        public Boolean email;
    }
}
