package company.tap.commondependencies.ApiModels;

import java.util.List;
import java.util.Map;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@JsonPropertyOrder({ "id", "status", "created", "legal_name", "country", "type", "not_for_profit", "is_licensed",
		"license", "capital", "relations", "taxable", "tax_number", "vat_id", "is_vat_acknowledged", "settlement", "settlement_by", "documents",
		"wallets", "branches", "bank_account", "billing_address" })
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiEntity extends ApiBaseModel {

	@NotNull
	@JsonProperty("legal_name")
	public ApiText legalName;
	@JsonProperty("is_licensed")
	public Boolean is_licensed;
	@JsonProperty("license_number")
	public String licenseNumber;
	public ApiLicense license;
	@JsonProperty("not_for_profit")
	public Boolean not_for_profit;
	@NotNull
	public String country;
	public String type;
	@JsonProperty("currency_code")
	public String currencyCode;
	@JsonProperty("taxable")
	public Boolean taxable;
	@JsonProperty("tax_number")
	public String taxNumber;
	@JsonProperty("settlement_by")
	public String settlementBy;
	public ApiSettlement settlement; // Added on 27OCT
	public List<ApiDocuments> documents;
	public List<ApiWallet> wallets;
	public List<ApiBranch> branches;
	@JsonProperty("bank_account")
	public ApiBankAccount bankAccount; // Added on 07OCT as goSell create account requires iban
	public ApiOperator operator; // Added to return default operator
	@JsonProperty("bank_accounts")
	public List<ApiBankAccount> bankAccounts;
	@JsonProperty("billing_address")
	public ApiAddress billingAddress;
	@JsonProperty("capital")
	public ApiEntityCapital capital;
	public List<Relations> relations;
	@JsonProperty("activities")
	public List<Activity> activities;
	@JsonProperty("vat_id")
	public String VATId;
	@JsonProperty("vat_acknowledged_by")
	public String vatAcknowledgedBy;
	@JsonProperty("vat_acknowledged_by_info")
	public ApiAcceptedBy vatAcknowledgedByInfo;
	@JsonProperty("is_vat_acknowledged")
	public Boolean isVatAcknowledged;
	@JsonProperty("AOA_file_id")
	public String AOAFileId;
	public Location location;
	@JsonProperty("data_status")
	public ApiEntityData<String> dataStatus;
	@JsonProperty("data_verification")
	public ApiEntityData<Map<String,String>> dataVerification;
	@JsonProperty("data_state")
	public String dataState;
	@JsonProperty("tax_data_state")
	public String taxDataState;

	/**
	 * for legacy migration
	 */
	public ApiWallet wallet;

	@Data
	@JsonPropertyOrder({ "id", "name", "source", "source_id", "is_external" })
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Relations {
		@JsonProperty("id")
		public String relationId;
		@JsonProperty("name")
		public Map<String, String> name;
		@JsonProperty("type")
		public String source;
		@JsonProperty("type_id")
		public String sourceId;
		@JsonProperty("is_external")
		public Boolean isExternal;
	}

	@Data
	@JsonPropertyOrder({ "id", "name" })
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Activity {
		@JsonProperty("id")
		public String activityId;
		@JsonProperty("name")
		public Map<String, String> name;
		@JsonProperty("isic_code")
		public String isicCode;
		public String action;
		@JsonProperty("mcc_value")
		private ApiMcc mccValue;
	}


	@Data
	@JsonPropertyOrder({ "id", "name" })
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Location {
		@JsonProperty("id")
		public String locationId;
		@JsonProperty("name")
		public Map<String, String> name;
	}
}
