/*
 * Copyright (c) 2021. Tap Payments
 * Author: Charan Dommara
 * Created On: 31 5 2021
 */

package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;

@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiAuthorizeBalance extends ApiBaseModel {
    @JsonProperty("wallet_id")
    public String walletId;
    @JsonProperty("balance_id")
    public String balanceId;
    public String currency;
    public double amount;
    public String type;
    @JsonProperty("authorize_balance_id")
    public String authorizeBalanceId;
    @JsonProperty("wallet_balance_id")
    public String walletBalanceId;
    @JsonProperty("net_amount")
    public double netAmount;
    @JsonProperty("net_available_amount")
    public double netAvailableAmount;
    @JsonProperty("capture_balance_id")
    public String captureBalanceId;
    @JsonProperty("settlement_id")
    public String settlementId;
    public Integer source;
    @JsonProperty("source_value")
    public String sourceValue;
    @JsonProperty("use_rewards")
    public boolean useRewards;
    @JsonProperty("net_rewards_amount")
    public double netRewardsAmount;
    @JsonProperty("total_amount")
    public double totalAmount;
    public ApiUsedAmount used;
}
