package company.tap.commondependencies.goSellModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import company.tap.commondependencies.ApiModels.ApiBankAccount;
import company.tap.commondependencies.ApiModels.ApiSettlement;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class goSellCreateAccountReq {
    public int response_code;
    public String response_message;
    public boolean transfer;
    public int merchant_id;
    public String country_code;
    public String currency_code;
    public String account_type;
    public String profile_name;
    public goSellContactInfo contact_info;
    public goSellCorporateInfo corporate_info;
    public ApiBankAccount bank_account_info;
    public String business_logo;
    public String access_token;
    public String organizationID;
    public String entityID;
    public String businessID;
    public String accountType;
    public String website_url;
    public String beneficiary_address;
    public String master_account_id;
    public ApiSettlement settlement;
    public boolean master_is_segment;
    public String master_segment_type;
    public boolean is_destination;
    public String walletId;
    public String access_type;
    public String status;
    public String settlement_by;
    public boolean allow_acceptance;
    @JsonProperty("go_data_merchant_id")
    public String goDataMerchantId;
    @JsonProperty("brand_info")
    public BrandInfo brandInfo;
    @JsonProperty("freelancer_info")
    public FreelancerInfo freelancerInfo;

    @NoArgsConstructor
    public static class BrandInfo {
        public String website;
    }

    @NoArgsConstructor
    public static class FreelancerInfo {
        @JsonProperty("license_number")
        public String licenseNumber;
    }
}
