/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.Helpers;

import com.google.common.base.Strings;
import company.tap.commondependencies.ApiModels.ApiHeaders;
import company.tap.commondependencies.Constants.CommonErrorMessages;
import company.tap.commondependencies.Models.CreateBy;
import company.tap.commondependencies.exceptions.UnauthorizedException;

public class CommonValidationHelper {

    public static void accessValidation(CreateBy createBy, ApiHeaders apiHeaders, String businessId) {
        if (Strings.isNullOrEmpty(apiHeaders.operatorId))
            throw new UnauthorizedException(CommonErrorMessages.UNAUTHORIZED_API_KEY);
        if (!Strings.isNullOrEmpty(apiHeaders.getSegmentId()) && apiHeaders.getSegmentId().substring(0, 3).equalsIgnoreCase("tap"))
            return;
        if (!Strings.isNullOrEmpty(businessId) && businessId.equalsIgnoreCase(apiHeaders.getBusinessId()))
            return;
        if (!Strings.isNullOrEmpty(createBy.segmentId) && createBy.segmentId.equalsIgnoreCase(apiHeaders.getSegmentId()))
            return;
        if (!Strings.isNullOrEmpty(createBy.businessId) && createBy.businessId.equalsIgnoreCase(apiHeaders.getBusinessId()))
            return;
        throw new UnauthorizedException(CommonErrorMessages.UNAUTHORIZED_API_KEY);
    }
}
