package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Builder
@Data
@JsonInclude(value = JsonInclude.Include.NON_NULL)
@NoArgsConstructor
@AllArgsConstructor
public class ApiBrandData<T> {

	private String status;
	@JsonProperty("name")
	private ApiText newName;
	@JsonProperty("activities")
	public T newActivities;
	@JsonProperty("channel_services")
	private T newChannelServices;
	private Operations operations;
//	@JsonProperty("customer_base")
//	private CustomerBase customerBase;
	private String terms;
	private String logo;
	private Segment segment;

	@Builder
	@NoArgsConstructor
	@AllArgsConstructor
	@Data
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Operations {
		@JsonProperty("business_start_date")
		private String businessStartDate;
		@JsonProperty("sales_range")
		private String salesRange;
		@JsonProperty("customer_base")
		private String customerBase;
		@JsonProperty("customer_base_location")
		private String customerBaseLocation;
	}

	@Builder
	@NoArgsConstructor
	@AllArgsConstructor
	@Data
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class CustomerBase {
		private String id;
		private String location;
	}
	
	@Builder
	@NoArgsConstructor
	@AllArgsConstructor
	@Data
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Segment {
		private String type;
		private String teams;
		private String sale;
	}
}
