package company.tap.commondependencies.Models;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import company.tap.commondependencies.ApiModels.ApiOperator;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
@JsonInclude(value = JsonInclude.Include.NON_NULL)
@NoArgsConstructor
public class PrivateMerchant {
	
	public boolean success;
	
	public String displayName;

	public String merchantId;

	public String businessId;

	public String entityId;

	public String brandId;

	public String branchId;

	public String walletId;

	public List<String> chargeCurrencies;
	
//	private List<String> bankAccountId;
	
	public String accessToken;
	
	public String legacyId;
	
	public long created;
	
	public boolean isArchived;
	
	public boolean isDeleted;
	
	public String status;
	
	public String featureVersion;
	
	public String baseCurrency;
	@JsonProperty("is_acceptance_allowed")
	public boolean isAcceptanceAllowed;
	@JsonProperty("is_payout_allowed")
	public boolean isPayoutAllowed;
	/**
	 * createdAt used for legacy migration
	 */
	@JsonProperty("created_at")
	public Date createdAt;
	@JsonProperty("marketplace")
	public Boolean isMarketPlace;
	@JsonProperty("marketplace_id")
	public String marketPlaceId;
	public ApiOperator operator;
	@JsonProperty("post")
	public Map<String, String> postUrl;
}
