package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Builder
@Data
@JsonInclude(value = JsonInclude.Include.NON_NULL)
@NoArgsConstructor
@AllArgsConstructor
public class ApiBankAccountData {

	public String iban;
	@JsonProperty("account_number")
	public String accountNumber;
	@JsonProperty("swift_code")
	public String swiftCode;
	@JsonProperty("bank_name")
	public String bankName;
	@JsonProperty("beneficiary_name")
	public String beneficiaryName;
	@JsonProperty("bank_statement_file_id")
	public String bankStatementFileId;
	@JsonProperty("is_acknowledged")
	public String isAcknowledged;
}
