package company.tap.commondependencies.Errors;

import java.util.ArrayList;
import java.util.List;

import company.tap.commondependencies.ApiModels.ApiErrors;
import company.tap.commondependencies.ApiModels.ErrorSource;
import company.tap.commondependencies.Helpers.ObjMapper;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import org.springframework.stereotype.Service;


@Service
class ErrorServices implements IErrorServices {

	public ResponseEntity<Object> Error(int code, String error, String description, HttpStatus httpStatus) {
		ApiErrors apiError = new ApiErrors();
		ApiErrors.ApiError err = apiError.new ApiError();
		err.code = String.valueOf(code);
		err.error = error;
		err.description = description;
		return getObjectResponseEntity(httpStatus, apiError, err);
	}

	private ResponseEntity<Object> getObjectResponseEntity(HttpStatus httpStatus, ApiErrors apiError, ApiErrors.ApiError err) {
		List<ApiErrors.ApiError> errors = new ArrayList<>();
		errors.add(err);
		apiError.errors = errors;
		try {
			return new ResponseEntity<>(ObjMapper.getInstance().writeValueAsString(apiError), httpStatus);
		} catch (JsonProcessingException e) {

			e.printStackTrace();
			return Error(Errors.Internal_server_error.getCode(), Errors.Internal_server_error.toString(),
					"Failed internal server error", HttpStatus.INTERNAL_SERVER_ERROR);
		}
	}

	public ResponseEntity<Object> Errors(int code, String error, String description, ErrorSource source,
			HttpStatus httpStatus) {
		ObjMapper.getInstance().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
		ObjMapper.getInstance().setSerializationInclusion(Include.NON_NULL);
		ApiErrors apiError = new ApiErrors();
		ApiErrors.ApiError err = apiError.new ApiError();
		err.code = String.valueOf(code);
		err.error = error;
		err.description = description;
		err.errors = source;
		return getObjectResponseEntity(httpStatus, apiError, err);
	}

}
