package company.tap.commondependencies.Country;

import company.tap.commondependencies.Helpers.DataUtilities;
import company.tap.commondependencies.Helpers.RestAPI;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

import static org.springframework.http.MediaType.APPLICATION_JSON;

@Service
class CountryServices implements ICountryServices {

	private String CommonApi = DataUtilities.getInstance().getUrlCommonUtilities();
	
	public Country getCountryByCountryIso(String CountryCode) {
		try {
			HttpHeaders headersCA = new HttpHeaders();
			headersCA.setContentType(APPLICATION_JSON);
			HttpEntity<String> entityToken = new HttpEntity<>(headersCA);
			return RestAPI.getInstance()
					.exchange(CommonApi + "country/iso/" + CountryCode, HttpMethod.GET, entityToken, Country.class)
					.getBody();

		} catch (Exception e) {
			return null;
		}
	}

	public Country getCountryByCountryId(String CountryId) {
		try {
			HttpHeaders headersCA = new HttpHeaders();
			headersCA.setContentType(APPLICATION_JSON);
			HttpEntity<String> entityToken = new HttpEntity<>(headersCA);
			return RestAPI.getInstance()
					.exchange(CommonApi + "country/" + CountryId, HttpMethod.GET, entityToken, Country.class)
					.getBody();

		} catch (Exception e) {
			return null;
		}
	}


}
