/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import company.tap.commondependencies.ApiModels.ApiBrand;
import company.tap.commondependencies.ApiModels.ApiGlobalUser;
import company.tap.commondependencies.ApiModels.ApiText;
import company.tap.commondependencies.Models.CreateBy;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
@JsonInclude(value = JsonInclude.Include.NON_NULL)
@NoArgsConstructor
public class PrivateBusiness {
    public boolean success;
    // idChange purpose - if any id exist new id will be returned. if idChange is true then ID has to be updated in goDataEntity
    public boolean idChange;
    public String businessId;
    public String individualId;
    public String userId;
    public Map<String,String> metaData;
    public List<String> entities;
    public String defaultUser;
    public ApiText name;
    public String type;
    public ApiGlobalUser contact_person;
    public List<ApiBrand> brands;
    public String status;
    public boolean isArchive;
    public boolean isDeleted;
    public long created;
    public CreateBy createBy;
    //to retrieve entity info to create operator for user
    public String walletId;
    public String legacyId;
    public String accessToken;
    public String developerOperatorId;
    public String segmentId;
    public List<String> identifications;
    public int createdLegacyId;
    /**
     * createdAt used for legacy migration
     */
    @JsonProperty("created_at")
    public Date createdAt;
}
