package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Builder
@Data
@JsonInclude(value = JsonInclude.Include.NON_NULL)
@NoArgsConstructor
@AllArgsConstructor
public class ApiEntityData {

	@JsonProperty("legal_name")
	public String legalName;
	@JsonProperty("country")
	public String Country;
	public String type;
	@JsonProperty("not_for_profit")
	public String notForProfit;
	public License license;
	public Capital capital;
	public Relations relations;
	@JsonProperty("tax_number")
	public String taxNumber;
	@JsonProperty("opened_by")
	public String openedBy;
	@JsonProperty("signed_by")
	public String signedBy;
	@JsonProperty("settlement_by")
	public String settlementBy;
	public ApiSettlement settlement;
	public String activities;
	@JsonProperty("billing_address")
	public String billingAddress;
	@JsonProperty("is_licensed")
	public String isLicensed;
	@JsonProperty("taxable")
	public String taxable;

	@Builder
	@Data
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	@NoArgsConstructor
	@AllArgsConstructor
	public static class License {
		public String status;
		public String provider;
		public String type;
		public String number;
		@JsonProperty("additional_info")
		public String additionalInfo;
		@JsonProperty("issuing_date")
		public String issuingDate;
		@JsonProperty("expiry_date")
		public String expiryDate;
	}

	@Builder
	@Data
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	@NoArgsConstructor
	@AllArgsConstructor
	public static class Capital {
		public String paid;
		public String subscribed;
		public String announced;
		public String shares;
	}

	@Builder
	@Data
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	@NoArgsConstructor
	@AllArgsConstructor
	public static class Relations {
		public String name;
		@JsonProperty("type")
		public String type;
		@JsonProperty("type_id")
		public String typeId;
		@JsonProperty("is_external")
		public String isExternal;
	}
}
