package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Builder
@Data
@JsonInclude(value = JsonInclude.Include.NON_NULL)
@NoArgsConstructor
@AllArgsConstructor
public class ApiBrandData {

	private String status;
	private String name;
	public String activities;
	@JsonProperty("channel_services")
	private String channelServices;
	private Operations operations;
	@JsonProperty("customer_base")
	private CustomerBase customerBase;
	private String terms;

	@Builder
	@NoArgsConstructor
	@AllArgsConstructor
	@Data
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Operations {
		@JsonProperty("business_start_date")
		private String businessStartDate;
		@JsonProperty("sales_range")
		private String salesRange;
	}

	@Builder
	@NoArgsConstructor
	@AllArgsConstructor
	@Data
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class CustomerBase {
		private String location;
	}
}
