package company.tap.commondependencies.Currency;

import company.tap.commondependencies.Helpers.DataUtilities;
import company.tap.commondependencies.Helpers.RestAPI;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

import static org.springframework.http.MediaType.APPLICATION_JSON;

@Service
class CurrencyServices implements ICurrencyServices {

	private final String CommonApi = DataUtilities.getInstance().getUrlCommonUtilities();

	private Currency getCurrency(String Code) {
		try {
			HttpHeaders headersCA = new HttpHeaders();
			headersCA.setContentType(APPLICATION_JSON);
			HttpEntity<String> entityToken = new HttpEntity<>(headersCA);
			return RestAPI.getInstance()
					.exchange(CommonApi + "currency/iso/" + Code, HttpMethod.GET, entityToken, Currency.class)
					.getBody();
		} catch (Exception e) {
			return null;
		}
	}

	public Currency getCurrencyByCountryIso2(String CountryCode) {
		return getCurrency(CountryCode);
	}

	public Currency getCurrencyByCurrencyCode(String CurrencyCode) {
		return getCurrency(CurrencyCode);
	}
	
	public Currency getCurrencyById(String CurrencyId) {
		try {
			HttpHeaders headersCA = new HttpHeaders();
			headersCA.setContentType(APPLICATION_JSON);
			HttpEntity<String> entityToken = new HttpEntity<>(headersCA);
			return RestAPI.getInstance()
					.exchange(CommonApi + "currency/" + CurrencyId, HttpMethod.GET, entityToken, Currency.class)
					.getBody();

		} catch (Exception e) {
			return null;
		}
	}

}
