package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Builder
@Data
@JsonInclude(value = JsonInclude.Include.NON_NULL)
@NoArgsConstructor
@AllArgsConstructor
public class ApiBrandData {

	private String status;
	private String name;
	@JsonProperty("channel_services")
	private ChannelService channelServices;
	private Operations operations;
	@JsonProperty("customer_base")
	private CustomerBase customerBase;
	private Terms terms;

	@Builder
	@NoArgsConstructor
	@AllArgsConstructor
	@Data
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class ChannelService {
		private String website;
		@JsonProperty("call_center")
		private String callCenter;
		@JsonProperty("physical_store")
		private String physicalStore;
		@JsonProperty("apple_store")
		private String appleStore;
		@JsonProperty("play_store")
		private String playStore;
		private String twitter;
		private String instagram;
		private String linkedin;
	}

	@Builder
	@NoArgsConstructor
	@AllArgsConstructor
	@Data
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Operations {
		@JsonProperty("business_start_date")
		private String businessStartDate;
		@JsonProperty("sales_range")
		private String salesRange;
	}

	@Builder
	@NoArgsConstructor
	@AllArgsConstructor
	@Data
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class CustomerBase {
		private String location;
	}

	@Builder
	@NoArgsConstructor
	@AllArgsConstructor
	@Data
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Terms {
		private String general;
		private String chargeback;
		private String refund;
	}
}
