/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.Mada.StandardCodes;

public enum ProcessingCodes {
    PurchaseOrPreAuthorizationCapture("000000", "Purchase or Preauthorization Capture or Debt Recovery from Default " +
            "Account"),
    Refund("200000", "Refund from Default Account"),
    PrAuthorizationOrPreAuthorizationExtension("900000", "Preauthorization or Preauthorization Extension from Default " +
            "Account"),
    Void("220000", "Void from Default Account");
    private String code;
    private String description;

    ProcessingCodes(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    public static ProcessingCodes get(String code) {
        for (ProcessingCodes e : ProcessingCodes.values()) {
            if (e.code.equals(code)) return e;
        }
        return null;
    }
}
