/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = false)
@JsonPropertyOrder({"id", "status", "created", "name", "contact", "nationality", "identification",
        "role", "is_authorized", "brands", "entity", "relation"})
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiUserRequest extends ApiBaseModel {
    @NotNull
    @JsonProperty("contact")
    public ApiPrimaryContact contact;
    @NotNull
    @JsonProperty("name")
    public ApiContactName name;

    @JsonProperty("nationality")
    public String nationality;

    @JsonProperty("identification")
    public ApiGlobalUser.Identification identification;

    @JsonProperty("brands")
    public List<String> brands;

    @JsonProperty("entity")
    public ApiIndividualType.ApiIndividualEntity entity;

    @JsonProperty("is_authorized")
    public Boolean isAuthorized;

    @JsonProperty("review_info")
    public boolean reviewInfo;

    @JsonProperty("send_invite")
    public boolean sendInvite;

    @JsonProperty("metadata")
    public HashMap<String, String> metaData;
    @JsonProperty("identifications")
    public List<String> identifications;
    @JsonProperty("documents")
    public List<String> documents;
    @JsonProperty("relations")
    public ApiEntity.Relations relations;
    @JsonProperty("role")
    public ApiRole role;
    @JsonProperty("action")
    public Integer action;

    @JsonProperty("names")
    public Map<String, ApiContactName> names;

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class ApiRole {
        @JsonProperty("id")
        public String id;
        @JsonProperty("name")
        public Map<String, String> name;
    }

}
